    <h2 class="mt-0"><i class="icon-history"></i>  <?php echo e(trans('messages.payments_history')); ?></h2>

    <table class="table table-box pml-table table-log">
        <tr>
            <th><?php echo e(trans('messages.created_at')); ?></th>
            <th><?php echo e(trans('messages.payment_action_method')); ?></th>
			<th width="35%"><?php echo e(trans('messages.payment_description')); ?></th>
            <th><?php echo e(trans('messages.order_id')); ?></th>
            <th><?php echo e(trans('messages.status')); ?></th>
        </tr>
        <?php foreach($subscription->getPayments()->get() as $key => $payment): ?>
            <tr>
                <td>
                    <span class="no-margin kq_search"><?php echo e(\Acelle\Library\Tool::formatDateTime($payment->created_at)); ?></span>
                    <span class="text-muted second-line-mobile"><?php echo e(trans('messages.created_at')); ?></span>
                </td>
                <td>
                    <strong class="text-info-800"><?php echo e(trans('messages.payment_action_' . $payment->action)); ?></strong>
                    <br>
                    <?php echo e($payment->getPaymentMethodName()); ?>

                </td>
				<td>
					<?php echo e($payment->description); ?>

					<?php if($payment->tax_number): ?>
						<div><span class="text-semibold"><?php echo e(trans('messages.tax_number')); ?>:</span> <?php echo e($payment->tax_number); ?></div>
					<?php endif; ?>
					<?php if($payment->billing_address): ?>
						<div><span class="text-semibold"><?php echo e(trans('messages.billing_address')); ?>:</span> <?php echo e($payment->billing_address); ?></div>
					<?php endif; ?>
				</td>
                <td><?php echo e($payment->getOrderID()); ?></td>
                <td>
					<span class="text-muted2 list-status pull-left">
						<span
                            <?php if($payment->status == 'failed'): ?>
                                data-popup='tooltip' title="<?php echo implode('; ', $payment->getErrorMessages()); ?>"
                            <?php endif; ?>
                        class="label label-sub label-flat bg-<?php echo e($payment->status); ?>"><?php echo e(trans('messages.subscription_payment_status_' . $payment->status)); ?></span>
					</span>
				</td>
            </tr>
        <?php endforeach; ?>
    </table>
