<?php $__env->startSection('title', trans('messages.license')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/interactions.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/touch.min.js')); ?>"></script>

	<script type="text/javascript" src="<?php echo e(URL::asset('js/listing.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

    <div class="page-title">
        <ul class="breadcrumb breadcrumb-caret position-right">
            <li><a href="<?php echo e(action("Admin\HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
        </ul>
        <h1>
            <span class="text-gear"><i class="icon-key"></i> <?php echo e(trans('messages.license')); ?></span>
        </h1>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <form action="<?php echo e(action('Admin\SettingController@license')); ?>" method="POST" class="form-validate-jqueryz">
        <?php echo e(csrf_field()); ?>


        <div class="tabbable">
            <?php echo $__env->make("admin.settings._tabs", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

            <div class="tab-content">

				<?php if($license_error): ?>
					<div class="alert alert-danger">
						<?php echo e($license_error); ?>

					</div>
				<?php endif; ?>


                <?php foreach($settings as $name => $setting): ?>
                    <?php if($setting['cat'] == 'license'): ?>
                        <?php if($current_license): ?>
							<div class="sub-section">
								<h3><?php echo e(trans('messages.license.your_license')); ?></h3>
								<p><?php echo e(trans('messages.your_current_license')); ?> <strong><?php echo e(trans('messages.license_label_' . \Acelle\Model\Setting::get('license_type'))); ?></strong></p>
								<h4>
									<?php echo e($current_license); ?>

								</h4>
							</div>
                        <?php else: ?>
							<div class="sub-section">
								<h3><?php echo e(trans('messages.license.your_license')); ?></h3>
								<p> <?php echo e(trans('messages.license.no_license')); ?> </p>
							</div>
						<?php endif; ?>

						<div class="sub-section">
							<h3><?php echo e(trans('messages.license.license_types')); ?></h3>
							<?php echo trans('messages.license_guide'); ?>

						</div>

						<div class="sub-section">
							<?php if(!$current_license): ?>
								<h3><?php echo e(trans('messages.verify_license')); ?></h3>
							<?php else: ?>
								<h3><?php echo e(trans('messages.change_license')); ?></h3>
							<?php endif; ?>
							<div class="row license-line">
								<div class="col-md-6">
									<?php echo $__env->make('helpers.form_control', [
										'type' => $setting['type'],
										'class' => (isset($setting['class']) ? $setting['class'] : "" ),
										'name' => $name,
										'value' => (request()->license ? request()->license : ''),
										'label' => trans('messages.enter_license_and_click_verify'),
										'help_class' => 'setting',
										'options' => (isset($setting['options']) ? $setting['options'] : "" ),
										'rules' => Acelle\Model\Setting::rules(),
									], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
								</div>
								<div class="col-md-6">
									<br />
									<div class="text-left">
										<?php if($current_license): ?>
											<button class="btn bg-teal"><i class="icon-check"></i> <?php echo e(trans('messages.change_license')); ?></button>
										<?php else: ?>
											<button class="btn bg-teal"><i class="icon-check"></i> <?php echo e(trans('messages.verify_license')); ?></button>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>


    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>