<?php if($servers->count() > 0): ?>
    <table class="table table-box pml-table"
        current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>"
    >
        <?php foreach($servers as $key => $server): ?>
            <tr>
                <td width="1%">
                    <div class="text-nowrap">
                        <div class="checkbox inline">
                            <label>
                                <input type="checkbox" class="node styled"
                                    custom-order="<?php echo e($server->custom_order); ?>"
                                    name="ids[]"
                                    value="<?php echo e($server->uid); ?>"
                                />
                            </label>
                        </div>
                    </div>
                </td>
                <td>
                    <h5 class="no-margin text-bold">
                        <a class="kq_search" href="<?php echo e(action('Admin\EmailVerificationServerController@edit', $server->uid)); ?>"><?php echo e($server->name); ?></a>
                    </h5>
                    <span class="text-muted">
                        <?php echo is_object($server->admin) ? '<i class="icon-user-tie"></i>' . $server->admin->displayName() : ''; ?>

                        <?php echo is_object($server->customer) ? '<i class="icon-user"></i>' . $server->customer->displayName() : ''; ?>

                    </span>
                    <br />
                    <span class="text-muted"><?php echo e(trans('messages.created_at')); ?>: <?php echo e(Tool::formatDateTime($server->created_at)); ?></span>
                </td>
                <td>
                    <div class="single-stat-box pull-left ml-20">
                        <span class="no-margin stat-num kq_search"><?php echo e($server->getTypeName()); ?></span>
                        <br />
                        <span class="text-muted"><?php echo e(trans('messages.email_verification_server_type')); ?></span>
                    </div>
                </td>
                <td>
                    <div class="single-stat-box pull-left ml-20">
                        <span class="text-muted"><strong><?php echo e(trans('messages.email_verification_server.credits_usage', ['count' => number_with_delimiter($server->getCreditUsage()) ])); ?></strong></span>
                        <br />
                        <span class="text-muted2"><?php echo e(trans('messages.sending_server.speed', ['limit' => $server->getSpeedLimitString()])); ?></span>
                    </div>
                </td>
                <td>
                    <span class="text-muted2 list-status pull-left">
                        <span class="label label-flat bg-<?php echo e($server->status); ?>"><?php echo e(trans('messages.email_verification_server_status_' . $server->status)); ?></span>
                    </span>
                </td>
                <td class="text-right text-nowrap">
                    <?php if(Auth::user()->admin->can('update', $server)): ?>
                        <a href="<?php echo e(action('Admin\EmailVerificationServerController@edit', ["uid" => $server->uid])); ?>" data-popup="tooltip" title="<?php echo e(trans('messages.edit')); ?>" type="button" class="btn bg-grey btn-icon"><i class="icon-pencil"></i> <?php echo e(trans('messages.edit')); ?></a>
                    <?php endif; ?>
                    <?php if(Auth::user()->admin->can('delete', $server) || Auth::user()->admin->can('disable', $server) || Auth::user()->admin->can('enable', $server)): ?>
                        <div class="btn-group">
                            <button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret ml-0"></span></button>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <?php if(Auth::user()->admin->can('enable', $server)): ?>
                                    <li>
                                        <a link-confirm="<?php echo e(trans('messages.enable_email_verification_servers_confirm')); ?>" href="<?php echo e(action('Admin\EmailVerificationServerController@enable', ["uids" => $server->uid])); ?>">
                                            <i class="icon-checkbox-checked2"></i> <?php echo e(trans('messages.enable')); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if(Auth::user()->admin->can('disable', $server)): ?>
                                    <li>
                                        <a link-confirm="<?php echo e(trans('messages.disable_email_verification_servers_confirm')); ?>" href="<?php echo e(action('Admin\EmailVerificationServerController@disable', ["uids" => $server->uid])); ?>">
                                            <i class="icon-checkbox-unchecked2"></i> <?php echo e(trans('messages.disable')); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if(Auth::user()->admin->can('delete', $server)): ?>
                                    <li>
                                        <a delete-confirm="<?php echo e(trans('messages.delete_email_verification_servers_confirm')); ?>" href="<?php echo e(action('Admin\EmailVerificationServerController@delete', ["uids" => $server->uid])); ?>">
                                            <i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
    <?php echo $__env->make('elements/_per_page_select', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo e($servers->links()); ?>

<?php elseif(!empty(request()->keyword) || !empty(request()->filters["type"])): ?>
    <div class="empty-list">
        <i class="icon-server"></i>
        <span class="line-1">
            <?php echo e(trans('messages.no_search_result')); ?>

        </span>
    </div>
<?php else: ?>
    <div class="empty-list">
        <i class="icon-server"></i>
        <span class="line-1">
            <?php echo e(trans('messages.email_verification_server_empty_line_1')); ?>

        </span>
    </div>
<?php endif; ?>
