<?php

namespace Acelle\Policies;

use Illuminate\Auth\Access\HandlesAuthorization;

class SystemJobPolicy
{
    use HandlesAuthorization;
    public $jobs = [
        'Acelle\Jobs\ImportSubscribersJob',
        'Acelle\Jobs\ExportSubscribersJob',
        'Acelle\Jobs\ExportSegmentsJob',
    ];
    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    public function delete(\Acelle\Model\User $user, \Acelle\Model\SystemJob $item)
    {
        if(array_search($item->name, $this->jobs) != false) {
            $data = json_decode($item->data);
            $list = \Acelle\Model\MailList::findByUid($data->mail_list_uid);
            return $list->customer_id == $user->customer->id && !$item->isRunning();
        }

        return false;
    }

    public function downloadImportLog(\Acelle\Model\User $user, \Acelle\Model\SystemJob $item)
    {
        $data = json_decode($item->data);
        $list = \Acelle\Model\MailList::findByUid($data->mail_list_uid);
        return $list->customer_id == $user->customer->id &&
            $item->name == 'Acelle\Jobs\ImportSubscribersJob' &&
            $data->status == 'done';
    }

    public function downloadExportCsv(\Acelle\Model\User $user, \Acelle\Model\SystemJob $item)
    {
        $data = json_decode($item->data);
        $list = \Acelle\Model\MailList::findByUid($data->mail_list_uid);
        return $list->customer_id == $user->customer->id &&
            ($item->name == 'Acelle\Jobs\ExportSubscribersJob' || $item->name == 'Acelle\Jobs\ExportSegmentsJob') &&
            $data->status == 'done';
    }

    public function cancel(\Acelle\Model\User $user, \Acelle\Model\SystemJob $item)
    {
        if(array_search($item->name, $this->jobs) != false) {
            $data = json_decode($item->data);
            $list = \Acelle\Model\MailList::findByUid($data->mail_list_uid);
            return $list->customer_id == $user->customer->id &&
                $item->isRunning();
        }

        return false;
    }
}
