<!DOCTYPE html>
<html lang="en">
<head>
	<title><?php echo $__env->yieldContent('title'); ?> - <?php echo e(\Acelle\Model\Setting::get("site_name")); ?></title>
	
	<?php echo $__env->make('layouts._favicon', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	
	<?php echo $__env->make('layouts._head', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<!-- Global stylesheets -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
	<link href="<?php echo e(URL::asset('assets/css/icons/icomoon/styles.css')); ?>" rel="stylesheet" type="text/css">
	<link href="<?php echo e(URL::asset('assets/css/bootstrap.css')); ?>" rel="stylesheet" type="text/css">
	<link href="<?php echo e(URL::asset('assets/css/core.css')); ?>" rel="stylesheet" type="text/css">
	<link href="<?php echo e(URL::asset('assets/css/components.css')); ?>" rel="stylesheet" type="text/css">
	<link href="<?php echo e(URL::asset('assets/css/colors.css')); ?>" rel="stylesheet" type="text/css">
	<link href="<?php echo e(URL::asset('css/app.css')); ?>" rel="stylesheet" type="text/css">
	<!-- /global stylesheets -->

	<!-- Core JS files -->
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/loaders/pace.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/bootstrap.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/loaders/blockui.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/ui/nicescroll.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/ui/drilldown.js')); ?>"></script>
	<!-- /core JS files -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/forms/styling/uniform.min.js')); ?>"></script>

	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/app.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/pages/login.js')); ?>"></script>
	<!-- /theme JS files -->

</head>

<body class="bg-slate-800">

	<!-- Page container -->
	<div class="page-container login-container">

		<!-- Page content -->
		<div class="page-content">

			<?php echo $__env->yieldContent('content'); ?>

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-white">
			<?php echo trans('messages.copy_right_light'); ?>			
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

</body>
</html>
