<?php $__env->startSection('title', trans('messages.languages')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/interactions.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/touch.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('js/listing.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

    <div class="page-title">
        <ul class="breadcrumb breadcrumb-caret position-right">
            <li><a href="<?php echo e(action("Admin\HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
        </ul>
        <h1>
            <span class="text-semibold"><i class="icon-list2"></i> <?php echo e(trans('messages.languages')); ?></span>
        </h1>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <p><?php echo e(trans('messages.languages.wording')); ?></p>
    <form class="listing-form"
        data-url="<?php echo e(action('Admin\LanguageController@listing')); ?>"
        per-page="<?php echo e(Acelle\Model\SendingDomain::$itemsPerPage); ?>"
    >
        <div class="row top-list-controls">
            <div class="col-md-9">
                <?php if($items->count() >= 0): ?>
                    <div class="filter-box">
                        <span class="filter-group">
                            <span class="title text-semibold text-muted"><?php echo e(trans('messages.sort_by')); ?></span>
                            <select class="select" name="sort-order">
                                <option value="languages.name"><?php echo e(trans('messages.name')); ?></option>
                                <option value="bounce_handlers.code"><?php echo e(trans('messages.code')); ?></option>
                                <option value="bounce_handlers.region_code"><?php echo e(trans('messages.region')); ?></option>
                                <option value="bounce_handlers.created_at"><?php echo e(trans('messages.created_at')); ?></option>
                                <option value="bounce_handlers.updated_at"><?php echo e(trans('messages.updated_at')); ?></option>
                            </select>
                            <button class="btn btn-xs sort-direction" rel="asc" data-popup="tooltip" title="<?php echo e(trans('messages.change_sort_direction')); ?>" type="button" class="btn btn-xs">
                                <i class="icon-sort-amount-asc"></i>
                            </button>
                        </span>
                        <span class="text-nowrap">
                            <input name="search_keyword" class="form-control search" placeholder="<?php echo e(trans('messages.type_to_search')); ?>" />
                            <i class="icon-search4 keyword_search_button"></i>
                        </span>
                    </div>
                <?php endif; ?>
            </div>
            <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check("create", new Acelle\Model\Language())): ?>
                <div class="col-md-3 text-right">
                    <a href="<?php echo e(action('Admin\LanguageController@create')); ?>" type="button" class="btn bg-info-800">
                        <i class="icon icon-plus2"></i> <?php echo e(trans('messages.create_language')); ?>

                    </a>
                </div>
            <?php endif; ?>
        </div>

        <div class="pml-table-container"></div>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>