<?php $__env->startSection('title', trans('messages.subscription')); ?>

<?php $__env->startSection('page_script'); ?>    
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/visualization/echarts/echarts.js')); ?>"></script>
    
    <script type="text/javascript" src="<?php echo e(URL::asset('js/chart.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('subscriptions._steps', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    
    <form enctype="multipart/form-data" action="<?php echo e(action('SubscriptionController@register', request()->plan_uid)); ?>" method="POST" class="form-validate-jqueryz subscription-form">
        <?php echo e(csrf_field()); ?>

        <div class="row">
            <div class="col-md-1"></div>
            <div class="col-md-10">
                <?php echo $__env->make('common.errors', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                
                <?php if($is_customer_logged_in): ?>
                    <h2 class="mt-0"><i class="icon-user"></i> <?php echo e(trans('messages.you_are_logged_in_as', ['name' => $customer->displayName()])); ?></h2>
                <?php else: ?>
                    <h2 class="mt-0"><i class="icon-user"></i> <?php echo e(trans('messages.customer_account')); ?>

                         <!--/ <span class="subhead text-white"><?php echo trans('messages.signin_if_has_account', [
                            'link' => url("/login")
                        ]); ?></span>-->
                    </h2>
                    <div class="panel">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="sub_section">
                                        <h2 class="text-semibold text-teal-800"><?php echo e(trans('messages.profile_photo')); ?></h2>
                                        <div class="media profile-image">
                                            <div class="media-left">
                                                <a href="#" class="upload-media-container">
                                                    <img preview-for="image" empty-src="<?php echo e(URL::asset('assets/images/placeholder.jpg')); ?>" src="<?php echo e(action('CustomerController@avatar', $customer->uid)); ?>" class="img-circle" alt="">
                                                </a>
                                                <input type="file" name="image" class="file-styled previewable hide">
                                                <input type="hidden" name="_remove_image" value='' />
                                            </div>
                                            <div class="media-body text-center">
                                                <h5 class="media-heading text-semibold"><?php echo e(trans('messages.upload_photo')); ?></h5>
                                                <?php echo e(trans('messages.photo_at_least', ["size" => "300px x 300px"])); ?>

                                                <br /><br />
                                                <a href="#upload" onclick="$('input[name=image]').trigger('click')" class="btn btn-xs bg-teal mr-10"><i class="icon-upload4"></i> <?php echo e(trans('messages.upload')); ?></a>
                                                <a href="#remove" class="btn btn-xs bg-grey-800 remove-profile-image"><i class="icon-trash"></i> <?php echo e(trans('messages.remove')); ?></a>
                                            </div>
                                        </div>
                                    </div>								
                                </div>
                                <div class="col-md-9">
                                    <div class="sub_section">
                                        <div class="row">
                                            <div class="col-md-5">
                                                <h2 class="text-semibold text-teal-800"><?php echo e(trans('messages.account')); ?></h2>
                                            </div>
                                            <div class="col-md-7">
                                                <h2 class="text-semibold text-teal-800"><?php echo e(trans('messages.basic_information')); ?></h2>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-5">
                                                <?php echo $__env->make('helpers.form_control', ['type' => 'text', 'name' => 'email', 'value' => $customer->email(), 'help_class' => 'profile', 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <?php echo $__env->make('helpers.form_control', ['type' => 'text', 'name' => 'first_name', 'value' => $customer->first_name, 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <?php echo $__env->make('helpers.form_control', ['type' => 'text', 'name' => 'last_name', 'value' => $customer->last_name, 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-5">
                                                <?php echo $__env->make('helpers.form_control', ['type' => 'password', 'label'=> trans('messages.new_password'), 'name' => 'password', 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                            </div>
                                            <div class="col-md-7">
                                                <?php echo $__env->make('helpers.form_control', ['type' => 'select', 'name' => 'timezone', 'value' => $customer->timezone, 'options' => Tool::getTimezoneSelectOptions(), 'include_blank' => trans('messages.choose'), 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>								
                                            </div>
                                        </div>
                                            
                                        <div class="row">
                                            <div class="col-md-5">
                                                <?php echo $__env->make('helpers.form_control', ['type' => 'password', 'name' => 'password_confirmation', 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                            </div>
                                            <div class="col-md-7">
                                                <?php echo $__env->make('helpers.form_control', ['type' => 'select', 'name' => 'language_id', 'label' => trans('messages.language'), 'value' => $customer->language_id, 'options' => Acelle\Model\Language::getSelectOptions(), 'include_blank' => trans('messages.choose'), 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                
                <br />
                
                <?php if(Acelle\Model\Setting::get('registration_recaptcha') == 'yes'): ?>
                    <div class="row">
                        <div class="col-md-3"></div>
                        <div class="col-md-6">
                            <?php if($errors->has('recaptcha_invalid')): ?>
                                <div class="text-danger text-center"><?php echo e($errors->first('recaptcha_invalid')); ?></div>
                            <?php endif; ?>
                            <?php echo Acelle\Library\Tool::showReCaptcha(); ?>

                        </div>
                    </div>
                <?php endif; ?>
                
                <div class="text-center">
                    <button type='submit' class="btn bg-teal"><i class="icon-check"></i> <?php echo e(trans('messages.register')); ?></button>
                </div>
            </div>
            <div class="col-md-1"></div>
        </div>
    </form>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.subscription', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>