					<div class="row">
						<div class="col-md-3">
							<div class="sub_section">
								<h2 class="text-semibold text-teal-800"><?php echo e(trans('messages.profile_photo')); ?></h2>
								<div class="media profile-image">
									<div class="media-left">
										<a href="#" class="upload-media-container">
											<img preview-for="image" empty-src="<?php echo e(URL::asset('assets/images/placeholder.jpg')); ?>" src="<?php echo e(action('CustomerController@avatar', $customer->uid)); ?>" class="img-circle" alt="">
										</a>
										<input type="file" name="image" class="file-styled previewable hide">
										<input type="hidden" name="_remove_image" value='' />
									</div>
									<div class="media-body text-center">
										<h5 class="media-heading text-semibold"><?php echo e(trans('messages.upload_photo')); ?></h5>
										<?php echo e(trans('messages.photo_at_least', ["size" => "300px x 300px"])); ?>

										<br /><br />
										<a href="#upload" onclick="$('input[name=image]').trigger('click')" class="btn btn-xs bg-teal mr-10"><i class="icon-upload4"></i> <?php echo e(trans('messages.upload')); ?></a>
										<a href="#remove" class="btn btn-xs bg-grey-800 remove-profile-image"><i class="icon-trash"></i> <?php echo e(trans('messages.remove')); ?></a>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-4">
							<div class="sub_section">
								<h2 class="text-semibold text-teal-800"><?php echo e(trans('messages.account')); ?></h2>

								<?php echo $__env->make('helpers.form_control', ['type' => 'text', 'name' => 'email', 'value' => $customer->email(), 'help_class' => 'profile', 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

								<?php echo $__env->make('helpers.form_control', ['type' => 'password', 'label'=> trans('messages.new_password'), 'name' => 'password', 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

								<?php echo $__env->make('helpers.form_control', ['type' => 'password', 'name' => 'password_confirmation', 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

							</div>
						</div>
						<div class="col-md-5">
							<div class="sub_section">
								<h2 class="text-semibold text-teal-800"><?php echo e(trans('messages.basic_information')); ?></h2>

								<div class="row">
									<div class="col-md-6">
										<?php echo $__env->make('helpers.form_control', ['type' => 'text', 'name' => 'first_name', 'value' => $customer->first_name, 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
									</div>
									<div class="col-md-6">
										<?php echo $__env->make('helpers.form_control', ['type' => 'text', 'name' => 'last_name', 'value' => $customer->last_name, 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
									</div>
								</div>

								<?php echo $__env->make('helpers.form_control', ['type' => 'select', 'name' => 'timezone', 'value' => $customer->timezone, 'options' => Tool::getTimezoneSelectOptions(), 'include_blank' => trans('messages.choose'), 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

								<?php echo $__env->make('helpers.form_control', ['type' => 'select', 'name' => 'language_id', 'label' => trans('messages.language'), 'value' => $customer->language_id, 'options' => Acelle\Model\Language::getSelectOptions(), 'include_blank' => trans('messages.choose'), 'rules' => $customer->rules()], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

							</div>
						</div>

					</div>
					<hr>
					<div class="text-left">
						<button class="btn bg-teal"><i class="icon-check"></i> <?php echo e(trans('messages.save')); ?></button>
					</div>
