<?php $__env->startSection('title', trans('messages.login')); ?>

<?php $__env->startSection('content'); ?>
                <!-- Advanced login -->
				<form class="" role="form" method="POST" action="<?php echo e(url('/login')); ?>">
                    <?php echo e(csrf_field()); ?>


					<div class="panel panel-body">

						<h4 class="text-semibold mt-0"><?php echo e(trans('messages.login')); ?></h4>

						<div class="form-group has-feedback has-feedback-left<?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
							<input id="email" type="email" class="form-control" name="email" placeholder="<?php echo e(trans("messages.email")); ?>"
								 value="<?php echo e(old('email') ? old('email') : (isset(\Acelle\Model\User::getAuthenticateFromFile()['email']) ? \Acelle\Model\User::getAuthenticateFromFile()['email'] : "")); ?>"
							>
							<div class="form-control-feedback">
								<i class="icon-envelop5 text-muted"></i>
							</div>
                            <?php if($errors->has('email')): ?>
                                <span class="help-block">
                                    <strong><?php echo e($errors->first('email')); ?></strong>
                                </span>
                            <?php endif; ?>
						</div>

						<div class="form-group has-feedback has-feedback-left<?php echo e($errors->has('password') ? ' has-error' : ''); ?>">
							<input id="password" type="password" class="form-control" name="password" placeholder="<?php echo e(trans("messages.password")); ?>"
								value="<?php echo e(isset(\Acelle\Model\User::getAuthenticateFromFile()['password']) ? \Acelle\Model\User::getAuthenticateFromFile()['password'] : ""); ?>"
							>
							<div class="form-control-feedback">
								<i class="icon-lock2 text-muted"></i>
							</div>
                            <?php if($errors->has('password')): ?>
                                <span class="help-block">
                                    <strong><?php echo e($errors->first('password')); ?></strong>
                                </span>
                            <?php endif; ?>
						</div>

						<div class="form-group login-options">
							<div class="row">
								<div class="col-sm-6">
									<label class="checkbox-inline">
										<input type="checkbox" class="styled" checked="checked" name="remember">
										<?php echo e(trans("messages.stay_logged_in")); ?>

									</label>
								</div>

								<div class="col-sm-6 text-right text-semibold">
									<a href="<?php echo e(url('/password/reset')); ?>"><?php echo e(trans("messages.forgot_password")); ?></a>
								</div>
							</div>
						</div>

						<?php if(\Acelle\Model\Setting::get('login_recaptcha') == 'yes'): ?>
							<?php echo \Acelle\Library\Tool::showReCaptcha($errors); ?>

						<?php endif; ?>

						<button type="submit" class="btn btn-lg bg-teal btn-block"><?php echo e(trans("messages.login")); ?> <i class="icon-circle-right2 position-right"></i></button>
					</div>

					<?php if(\Acelle\Model\Setting::get('enable_user_registration') == 'yes'): ?>
						<div class="text-center">
							<?php echo trans('messages.need_a_account_create_an_one', [
								'link' => action('SubscriptionController@selectPlan')
							]); ?>

						</div>
					<?php endif; ?>
				</form>
				<!-- /advanced login -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.clean', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>